\version "2.24.0"

\paper {
 %#(set-paper-size "a4")
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "O, frunte-nsângerată"
  subtitle = "Matthäus Passion"
  subsubtitle = "Coral 'O Haupt voll Blut und Wunden'"
  composer =  \markup \center-column { "Johann Sebastian Bach" \small 
  "(1685 – 1750)" }
  %meter = "Andante"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key d \minor
  \time 4/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOff
}


textOne = \lyrics {
   O, frun -- te-n -- sân -- ge -- ra -- tă
   de chi -- nuri fă -- ră preţ!
   O, frun -- te-n -- cu -- nu -- na -- tă
   cu spini şi cu dis -- preţ!
   O, frun -- te, al -- tă -- da -- tă
   scăl -- da -- tă-n foc ce -- resc,
   Azi eşti în -- tu -- ne -- ca -- tă,
   dar eu Te pre -- ţu -- iesc! 
   
 % O  Haupt voll Blut und Wun -- den, voll Schmerz und vol -- ler Hohn!
 % O  Haupt, zu Spott ge- bun -- den mit ei -- ner Dor -- nen -- kron'!
 % O  Haupt, sonst schön ge -- zie -- ret mit höch -- ster Ehr' und Zier,
 % jetzt a -- ber hoch schimp -- fi -- ret: ge -- grü -- ßet seist du mir!
}  

textTwo = \lyrics {
   Ne -- spu -- sa Ta du -- re -- re
   m-a -- pa -- să as -- tăzi greu!
   Că mul -- te Tu-n -- du -- rat -- ai,
   de vi -- nă-s nu -- mai eu!
   În -- du -- ră -- Te de mi -- ne,
   o, nu Te de -- păr -- ta!
   În -- du -- ră -- Te şi-m -- par -- te-mi
   mi -- los -- ti -- vi -- rea Ta!
   
 % Du ed -- les An -- ge -- sich -- te, vor dem sonst schrickt und scheut
 % das gro -- ße Welt -- ge -- rich -- te, wie bist du so be -- speit!
 % Wie bist du so er -- blei -- chet, wer hat dein Au -- gen -- licht,
 % dem sonst kein Licht nicht glei -- chet, so schänd -- lich zu -- ge -- richt't?
}  

sopMusic = \relative c'' {
  a4 | 
  d c bes a |
  g2 a4 \fermata e' |
  f f e8([ d]) e4 |
  d2. \fermata  a4 |
  d c bes a |
  g2 a4 \fermata  e' |
  f f e8([ d]) e4 |
  d2. \fermata  f4 |
  e8([ d]) c4 d e |
  f2 f4 \fermata  c |
  d c bes8([ a]) bes4 |
  a2. \fermata f'!4 |
  e8([ f]) g4 f e |
  d2 e4 \fermata  a, |
  bes a g c |
  a2. \fermata  \bar "|."
}


altMusic = \relative c' {
  f4 | 
  f8([ g]) a4 d,8([ e]) f4 |
  f( e) f a |
  a a a a8([ g]) |
  f2.  f4 |
%%5  
  f8([ g]) a4 d,8([ e]) f4 |
  f( e) f  a |
  a a a a8([ g]) |
  f2.  a4 |
  g g8([ f]) f4 bes |
%%10
  bes( a8[ g]) a4  a |
  a8([ g]) a4 g8([ fis]) g4 |
  fis2.  g4 |
  g c c c |
  c( b) c  f,8([ e]) |
%%15
  d8([ e]) f4 f e |
  f2.
}

tenorMusic = \relative c' {
  d4 | 
  d8([ e]) f4 g c, |
  d( c) c e |
  e d d cis |
  a2.  d4 |
%%5
  d8([ e]) f4 g c, |
  d( c) c  e |
  e d d cis |
  a2. d8([ c]) |
  bes4 c c bes8([ c]) |
%%10
  d4( c8[ bes]) c4 f8([ ees]) |
  d4 d d d |
  d2.  d4 |
  c8([ d]) e4 f g |
  a( g) g c, |
%%15
  bes c c8([ bes16 a]) g8([ c]) |
  c2.
}

bassMusic = \relative c {
  d'8([ c]) | 
  bes4 a g f |
  bes,( c) f cis |
  d8([ e]) f([ g]) a4 a, |
  d2. d'8([ c]) |
  bes4 a g f |
  bes,( c) f cis |
  d8([ e]) f([ g]) a4 a,4 |
  d2. d4 |
  g a bes8([ a]) g4 |
  f2 f4 f |
  bes fis g g, |
  d'2. b4 |
  c c'8([ b]) a4 g |
  f( g) c, f |
  g a8([ bes]) c4 c, |
  f2.
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \set Staff.instrumentName = #"S"
      \new Voice { \global \sopMusic }
      \addlyrics { \textOne }
      \addlyrics { \textTwo }
    >>

    \new Staff <<
     \set Staff.instrumentName = #"A"  
     \new Voice { \global \altMusic }
     %\addlyrics { \altWords  }
    >>
    
    \new Staff <<
     \set Staff.instrumentName = #"T"   
     \clef "G_8"
     \new Voice { \global \tenorMusic }
     \addlyrics { \textOne }
     \addlyrics { \textTwo }
    >>
    
    \new Staff <<
      \set Staff.instrumentName = #"B"
      \clef bass
      \new Voice { \global \bassMusic }
      %\addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 40
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
